using System;
using System.Text;
using System.Xml.Serialization;

namespace com.swvoyages.reservation {

	///
	/// <summary>La classe <code>CarAvailability</code> gre les donnes
	/// d'une disponibilit de la centrale de rservation automobile,
	/// partenaire de la socit SW-Voyages.</summary>
	///
	[SoapTypeAttribute("CarAvailability", 
		 "http://www.sw-automobilisme-xml.org:8080/reservation_sw-automobilisme-xml/schemas/ReservationService-schema")]
	public class CarAvailability {
		
		private static Random idGenerator = new Random();

		private int Id = 0;

		private String CarRentalCompany = "";
		private String CarCategory = "";
		private String CarModel = "";
		private float PricePerWeek = 0;
		private float PricePerDay = 0;

		private int RemoteId = 0;

		///
		/// <summary>Le constructeur de disponibilit de la centrale 
		/// de rservation automobile.</summary>
		///
		public CarAvailability() {
			this.Id = id;
		}

		///
		/// <summary>Renvoie l'identifiant de la disponibilit
		/// locale.</summary>
		///
		public int id {
			get {
				lock(this) {
					if (Id == 0) {
						Id = idGenerator.Next();
					}
					return Id;
				}
			}
			set {
			}
		}

		///
		/// <summary>Accesseurs du nom de la socit de location
		/// de vhicules.</summary>
		///
		public String carRentalCompany {
			get {
				return CarRentalCompany;
			}
			set {
				this.CarRentalCompany = value;
			}
		}

		///
		/// <summary>Accesseurs de la catgorie de vhicule.</summary>
		///
		public String carCategory {
			get {
				return CarCategory;
			}
			set {
				this.CarCategory = value;
			}
		}

		///
		/// <summary>Accesseurs du modle du vhicule.</summary>
		///
		public String carModel {
			get {
				return CarModel;
			}
			set {
				this.CarModel = value;
			}
		}

		///
		/// <summary>Accesseurs du prix de rservation par semaine.
		/// </summary>
		///
		public float pricePerWeek {
			get {
				return PricePerWeek;
			}
			set {
				this.PricePerWeek = value;
			}
		}

		///
		/// <summary>Accesseurs du prix de rservation par jour.
		/// </summary>
		///
		public float pricePerDay {
			get {
				return PricePerDay;
			}
			set {
				this.PricePerDay = value;
			}
		}

		///
		/// <summary>Accesseurs de l'identifiant de la disponibilit
		/// du partenaire.</summary>
		///
		public int remoteId {
			get {
				return RemoteId;
			}
			set {
				this.RemoteId = value;
			}
		}

		///
		/// <summary>Renvoie une reprsentation textuelle de la
		/// disponibilit du partenaire.</summary> 
		///
		/// <returns>une reprsentation textuelle de la	disponibilit.
		/// </returns>
		///
		public String toString() {
			StringBuilder sb = new StringBuilder();
			sb.Append("\r");
			sb.Append(GetType().FullName);
			sb.Append("@");
			sb.Append(System.Convert.ToString(GetHashCode(), 16));
			return sb.ToString();
		}
	}
}